/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.select;

import java.util.ArrayList;
import java.util.HashMap;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiSelectionListener;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;

public class GuiDialogSelection
extends SubGuiInterface
implements ICustomScrollListener {
    private final HashMap<String, DialogCategory> categoryData = new HashMap();
    private final HashMap<String, Dialog> dialogData = new HashMap();
    private GuiSelectionListener listener;
    private GuiCustomScroll scrollCategories;
    private GuiCustomScroll scrollDialogs;
    public DialogCategory selectedCategory;
    public Dialog selectedDialog;
    public int id;

    public GuiDialogSelection(int dialog, int id) {
        this.drawDefaultBackground = false;
        this.title = "";
        this.setBackground("menubg.png");
        this.xSize = 366;
        this.ySize = 226;
        this.id = id;
        this.selectedDialog = DialogController.instance.dialogs.get(dialog);
        if (this.selectedDialog != null) {
            this.selectedCategory = this.selectedDialog.category;
        }
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (button.getID() == 2) {
            if (this.selectedDialog != null) {
                this.scrollDoubleClicked(null, null);
            } else {
                this.close();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.parent instanceof GuiSelectionListener) {
            this.listener = (GuiSelectionListener)this.parent;
        }
        this.addLabel(new GuiNpcLabel(0, "gui.categories", this.guiLeft + 8, this.guiTop + 4));
        this.addLabel(new GuiNpcLabel(1, "dialog.dialogs", this.guiLeft + 175, this.guiTop + 4));
        this.addButton(new GuiNpcButton(2, this.guiLeft + this.xSize - 26, this.guiTop + 4, 20, 20, "X"));
        this.categoryData.clear();
        for (DialogCategory category : DialogController.instance.categories.values()) {
            this.categoryData.put(category.title, category);
        }
        this.dialogData.clear();
        if (this.selectedCategory != null) {
            for (Dialog dialog : this.selectedCategory.dialogs.values()) {
                this.dialogData.put(dialog.title, dialog);
            }
        }
        if (this.scrollCategories == null) {
            this.scrollCategories = new GuiCustomScroll(this, 0);
            this.scrollCategories.setSize(170, 200);
        }
        this.scrollCategories.setList(new ArrayList<String>(this.categoryData.keySet()));
        if (this.selectedCategory != null) {
            this.scrollCategories.setSelected(this.selectedCategory.title);
        }
        this.scrollCategories.guiLeft = this.guiLeft + 4;
        this.scrollCategories.guiTop = this.guiTop + 14;
        this.addScroll(this.scrollCategories);
        if (this.scrollDialogs == null) {
            this.scrollDialogs = new GuiCustomScroll(this, 1);
            this.scrollDialogs.setSize(170, 200);
        }
        this.scrollDialogs.setList(new ArrayList<String>(this.dialogData.keySet()));
        if (this.selectedDialog != null) {
            this.scrollDialogs.setSelected(this.selectedDialog.title);
        }
        this.scrollDialogs.guiLeft = this.guiLeft + 175;
        this.scrollDialogs.guiTop = this.guiTop + 14;
        this.addScroll(this.scrollDialogs);
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getID() == 0) {
            this.selectedCategory = this.categoryData.get(this.scrollCategories.getSelected());
            this.selectedDialog = null;
            this.scrollDialogs.setSelect(-1);
        }
        if (scroll.getID() == 1) {
            this.selectedDialog = this.dialogData.get(this.scrollDialogs.getSelected());
        }
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        if (this.selectedDialog == null) {
            return;
        }
        if (this.listener != null) {
            this.listener.selected(this.selectedDialog.id, this.selectedDialog.title);
        }
        this.close();
    }
}

